<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Login extends CI_Controller {

	function __construct() {
		parent::__construct();
		$this->load->model('login_model');
		date_default_timezone_set('Asia/Jakarta');
		$this->load->library('user_agent');
		$this->load->library('form_validation');
	}

	public function index() {
		$this->load->view('v_login');
	}

	public function auth() {
		$username = htmlspecialchars($this->input->post('username', TRUE), ENT_QUOTES);
		$password = htmlspecialchars($this->input->post('password', TRUE), ENT_QUOTES);
		$password_hash = md5($password);
		$tgl = date('Y-m-d H:i:s');
		$jamskr=date('H:i:s');
		$browser = $this->agent->browser() . ' ' . $this->agent->version();
		$os = $this->agent->platform();
		$ip = $this->input->ip_address();

		$cek_user = $this->login_model->cek_user($username, $password_hash);

		if ($cek_user->num_rows() > 0) {
			$data = $cek_user->row_array();
			$online=$data['online'];
	
			        $jawal=$data['jamawal'];
			        $jakhir=$data['jamakhir'];
			        if($jamskr>=$jawal && $jamskr<$jakhir) {
			                $username = $data['id_user'];
        	                $nama = $data['nm_user'];
			                $akses = $data['akses'];
			                $kdtoko = $data['kd_toko'];
			                $kdc = $data['kdcabang'];
			                $this->session->set_userdata('masuk', TRUE);
			                $this->session->set_userdata('akses', $akses);
			                $this->session->set_userdata('ses_username', $username);
			                $this->session->set_userdata('ses_nama', $nama);
			                $this->session->set_userdata('kd_toko', $kdtoko);
			                $this->session->set_userdata('kdc', $kdc);
			                $this->db->query("update tabel_user set online='1',jamlogin=curtime(),jamlogout='00:00:00' where id_user='$username' and online='0';");
			                $this->db->query("INSERT INTO tabel_agent (user,tgl,browser,os,ip) VALUES ('$username','$tgl','$browser','$os','$ip')");
			                echo $this->session->set_flashdata('msg', 'Selamat Datang, ' . $nama . ' ;)');
			                redirect('dashboard/', 'refresh');
			        } else {
			                $url = base_url();
			                echo $this->session->set_flashdata('msg', 'Maaf Anda Login Diluar jam Opersioanl!!! :(');
			                redirect($url);    
			                }
			              
		} else {
			$url = base_url();
			echo $this->session->set_flashdata('msg', 'Username atau Password salah! :(');
			redirect($url);
		}
	}

	public function logout() {
	    $username = $this->session->userdata['ses_username'];
	     $this->db->query("update tabel_user set online='0',jamlogout=curtime() where id_user='$username' and online='1';");
		$this->session->sess_destroy();
		$array_items = array('masuk' => '', 'akses' => '','ses_username' => '','ses_nama' => '','kd_toko' => '');
        $this->session->unset_userdata($array_items);
		$url = base_url();
		redirect($url);
	}
    public function ganti_password()    {
        $username = $this->session->userdata['ses_username'];
        
        $this->form_validation->set_rules('pw_baru','password baru','required');
        $this->form_validation->set_rules('pw_lama','password lama','required');
        $this->form_validation->set_message('required','%s wajib diisi');
        $this->form_validation->set_error_delimiters('<p class="alert">','</p>');
        $password = htmlspecialchars($this->input->post('pw_lama', TRUE), ENT_QUOTES);
        $password_hash = md5($password);
        
        if( $this->form_validation->run() == FALSE ){
            $this->load->view('ganti_password');
        } else {
            $post = $this->input->post();
            $tabel='tabel_user';
            $data = array(
                'password' => md5($post['pw_baru']),
            );
            $cek_user = $this->login_model->cek_user($username, $password_hash);
            if ($cek_user->num_rows() > 0) {
                	$url = base_url();
                    $this->login_model->update($username, $data, $tabel);
                    echo $this->session->set_flashdata('msg', 'Ganti Pasword Sukses, Silahkan Login Dengan Pasword Baru! :(');
                    $this->db->query("update tabel_user set online='0' where id_user='$username' and online='1';");
                   	redirect($url);
            } else {
               	$url = base_url();
			    echo $this->session->set_flashdata('msg', 'Username atau Password Lama salah! :(');
			    $this->load->view('ganti_password'); 
            }
            


        }	
    }
}

/* End of file Login.php */
/* Location: ./application/controllers/Login.php */