<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Kasir_model extends CI_Model {

	public function get_toko() {
		$user = $this->session->userdata('kd_toko');
		$query = $this->db->query("SELECT * FROM tabel_toko where kd_toko='$user';");
		return $query->row();
	}
	public function get_tokoku($kdtoko) {
		$query = $this->db->query("SELECT * FROM tabel_toko where kd_toko='$kdtoko';");
		return $query->row();
	}

	public function get_detail_produk($idbarang) {
	    $kdtoko = $this->session->userdata('kd_toko');
		$hsl = $this->db->query("SELECT tabel_stok_toko.stok, tabel_barang.nm_barang, tabel_satuan_barang.nm_satuan, tabel_barang.hrg_beli, tabel_barang.hrg_jual, tabel_kategori_barang.nm_kategori FROM tabel_barang 
		LEFT JOIN tabel_stok_toko ON tabel_barang.kd_barang = tabel_stok_toko.kd_barang
		LEFT JOIN tabel_kategori_barang ON tabel_barang.kd_kategori = tabel_kategori_barang.kd_kategori 
		LEFT JOIN tabel_satuan_barang ON tabel_barang.kd_satuan = tabel_satuan_barang.kd_satuan WHERE tabel_barang.kd_barang='$idbarang' and tabel_stok_toko.kd_toko='$kdtoko'");
		if ($hsl->num_rows() > 0) {
			foreach ($hsl->result() as $data) {
				$hasil = array(
					'namaproduk' => $data->nm_barang,
					'stok' => $data->stok,
					'harga' => $data->hrg_jual,
					'kategori' => $data->nm_kategori,
					'harga_beli' => $data->hrg_beli,
					'satuan' => $data->nm_satuan,
				);
			}
		}
		return $hasil;
	}
	public function getDataMenu() {
		$noresi = $this->uri->segment(3);
		$kod = $this->db->query("select jnsmenu,kdharga,kdcabang from tabel_penjualan where no_faktur_penjualan='$noresi';");
		$kode=$kod->row_array();
		$tgl=date('Y-m-d');
		$kdjns='J01';
		if(isset($kode)) {
		    $kdjns=$kode['jnsmenu'];
		    $kdharga=$kode['kdharga'];
		    $kdcabang=$kode['kdcabang'];
		}
		
		$this->db->join('hargajual AS b', 'a.kode_menu = b.kdbrg', 'left');
		$this->db->join('tabel_penjualan AS c', 'b.kdcabang = c.kdcabang and b.kdharga = c.kdharga', 'left');
		$this->db->where('a.jenisbrg', $kdjns);
		$this->db->where('c.no_faktur_penjualan', $noresi);
		$this->db->where('b.tglawal<=', $tgl);
		$this->db->where('b.tglakhir>=', $tgl);
		$this->db->where('a.stat', '1');
		$this->db->order_by('a.jenisbrg');
		$this->db->order_by('a.kode_menu');
		return $this->db->get('tabel_menu AS a');
	}

	public function cek_stok_mutasi($kode) {
	    $kdtoko = $this->session->userdata('kd_toko');
		return $this->db->query("SELECT * FROM tabel_stok_toko WHERE kd_barang='$kode' and kd_toko='$kdtoko'");
	}

	public function get_list($nofak) {
		return $this->db->select('tabel_rinci_penjualan.*')
			->where('tabel_rinci_penjualan.no_faktur_penjualan', $nofak)
			->get('tabel_rinci_penjualan')
			->result();
	}
	public function get_list_dpr() {
	    $waktu = date('Y-m-d');
	    $this->db->select("sum(a.jumlah) as jumlah,a.kd_barang,a.nm_barang,a.jenis,a.nourut,a.no_faktur_penjualan");
		$this->db->join('tabel_penjualan AS b', 'a.no_faktur_penjualan = b.no_faktur_penjualan', 'left');
		$this->db->where('b.tgl_penjualan', $waktu);
		$this->db->where('b.layanan', '2');
		$this->db->group_by('a.kd_barang');
		return $this->db->get('tabel_rinci_penjualan AS a');
			
	}
	public function detail_faktur($nofak) {
		return $this->db->select('tabel_penjualan.*')
			->where('tabel_penjualan.no_faktur_penjualan', $nofak)
			->where('tabel_penjualan.selesai', '1')
			->get('tabel_penjualan')
			->row();
	}
public function detail_faktur_dpr() {
        $waktu = date('Y-m-d');
		return $this->db->select('tabel_penjualan.*')
			->where('tabel_penjualan.tgl_penjualan', $waktu)
			->where('tabel_penjualan.selesai', '1')
			->get('tabel_penjualan')
			->row();
	}


	public function getProdukRetur($nofak, $kd_barang) {
		return $this->db->select('tabel_rinci_penjualan.*')
			->where('tabel_rinci_penjualan.no_faktur_penjualan', $nofak)
			->where('tabel_rinci_penjualan.kd_barang', $kd_barang)
			->get('tabel_rinci_penjualan');
	}

	public function getStokRetur($kd_barang) {
	    $kdtoko = $this->session->userdata('kd_toko');
		return $this->db->query("SELECT * FROM tabel_stok_toko WHERE kd_barang='$kd_barang' and kd_toko='$kdtoko'");
	}
	public function getStokdetail($nobukti,$tgl) {
	    $kdtoko = $this->session->userdata('kd_toko');
		return $this->db->query("SELECT a.* FROM stokdetail a,stokheader b WHERE a.nobukti=b.nobukti and b.kegd='$kdtoko' and b.tgl='$tgl' and a.nobukti='$nobukti' and a.st<>'2' and b.st<>'6'");
	}

	public function dataTransaksiHariIni($tgl,$kdtoko) {
        $this->db->query("delete from tanggal where  kdcabang='$kdtoko';");
		$this->db->query("delete from rekapharian where jenis<>'6' and tgl='$tgl' and  kdcabang='$kdtoko';");
		$this->db->query("insert ignore into tanggal(tgl,kdcabang) value ('$tgl','$kdtoko');");
		$this->db->query("insert ignore into rekapharian(jenis,tgl,kdcabang,kode,keterangan,nilai,nppn)
						 SELECT '1','$tgl','$kdtoko',a.kdharga,a.keterangan,
						 IFNULL((SELECT SUM(total_penjualan_sdiskon) FROM tabel_penjualan WHERE selesai='1' and kdharga=a.kdharga AND tgl_penjualan='$tgl' and kdcabang='$kdtoko'),0) AS reg,
						 IFNULL((SELECT SUM(nppn) FROM tabel_penjualan WHERE selesai='1' and kdharga=a.kdharga AND tgl_penjualan='$tgl' and kdcabang='$kdtoko'),0) AS nppn
						 FROM kodeharga a;");					 				 
		$this->db->query("insert ignore into rekapharian(jenis,tgl,kdcabang,kode,keterangan,nilai,nppn)
						 SELECT '2','$tgl','$kdtoko',a.kdharga,a.keterangan,IFNULL((SELECT SUM(ndisc) FROM tabel_penjualan WHERE selesai='1' and kdharga=a.kdharga AND tgl_penjualan='$tgl' and kdcabang='$kdtoko'),0) AS reg,0
						 FROM kodeharga a;");				 
						 
        $this->db->query("insert ignore into rekapharian(jenis,tgl,kdcabang,kode,keterangan,nilai,nppn)
						 SELECT '7','$tgl','$kdtoko',a.kdharga,a.keterangan,IFNULL((SELECT SUM(ongkir) FROM tabel_penjualan WHERE selesai='1' and kdharga=a.kdharga AND tgl_penjualan='$tgl' and kdcabang='$kdtoko'),0) AS reg,0
						 FROM kodeharga a;");				 						 
						 
		$this->db->query("insert ignore into rekapharian(jenis,tgl,kdcabang,kode,keterangan,nilai,nppn)
						 SELECT '3','$tgl','$kdtoko',a.kdbayar,a.keterangan,
						 IFNULL((SELECT SUM(netto) FROM tabel_penjualan WHERE selesai='1' and jnsbayar=a.kdbayar AND tgl_penjualan='$tgl' and kdcabang='$kdtoko'),0) AS reg,
						 IFNULL((SELECT SUM(nppn) FROM tabel_penjualan WHERE selesai='1' and jnsbayar=a.kdbayar AND tgl_penjualan='$tgl' and kdcabang='$kdtoko'),0) AS nppn
						 FROM jenispembayaran a where kdbayar<>'1';");		
		$this->db->query("insert ignore into rekapharian(jenis,tgl,kdcabang,kode,keterangan,nilai,nppn)
						 SELECT '4','$tgl','$kdtoko',a.kdharga,a.keterangan,
						 IFNULL((SELECT SUM(total_penjualan_sdiskon) FROM tabel_penjualan WHERE waktu<='16:00:00' and selesai='1' and kdharga=a.kdharga AND tgl_penjualan='$tgl' and kdcabang='$kdtoko'),0) AS reg,
						 IFNULL((SELECT SUM(nppn) FROM tabel_penjualan WHERE waktu<='16:00:00' and selesai='1' and kdharga=a.kdharga AND tgl_penjualan='$tgl' and kdcabang='$kdtoko'),0) AS nppn
						 FROM kodeharga a;");				 
		$this->db->query("insert ignore into rekapharian(jenis,tgl,kdcabang,kode,keterangan,nilai,nppn)
						 SELECT '5','$tgl','$kdtoko',a.kdharga,a.keterangan,
						 IFNULL((SELECT SUM(total_penjualan_sdiskon) FROM tabel_penjualan WHERE waktu>'16:00:00' and selesai='1' and kdharga=a.kdharga AND tgl_penjualan='$tgl' and kdcabang='$kdtoko'),0) AS reg,
						 IFNULL((SELECT SUM(nppn) FROM tabel_penjualan WHERE waktu>'16:00:00' and selesai='1' and kdharga=a.kdharga AND tgl_penjualan='$tgl' and kdcabang='$kdtoko'),0) AS nppn
						 FROM kodeharga a;");							 
		return $this->db->select('waktu,total_penjualan,ndisc as diskon,netto as total_penjualan_sdiskon,ket,id_user,ongkir,no_faktur_penjualan,tgl_penjualan,nppn,kdcabang,
								IF(kdharga="KH01",IF(layanan="1",total_penjualan_sdiskon,0),0) AS reg,
								IF(kdharga="KH01",IF(layanan="2",total_penjualan_sdiskon,0),0) AS regta,
								IF(kdharga="KH01",IF(layanan="3",total_penjualan_sdiskon,0),0) AS regdo,
								IF(kdharga="KH02",total_penjualan_sdiskon,0) AS gofood,
								IF(kdharga="KH03",total_penjualan_sdiskon,0) AS grab,
								IF(kdharga="KH04",total_penjualan_sdiskon,0) AS shopee,
								IF(kdharga="KH05",total_penjualan_sdiskon,0) AS regma
								')
			->where('tabel_penjualan.tgl_penjualan', $tgl)
			->where('tabel_penjualan.selesai', '1')
			->where('tabel_penjualan.kdcabang', $kdtoko)
			->order_by('no_faktur_penjualan')
			->get('tabel_penjualan');
	
	}
	
	public function dataTransaksiHariInid1($jam,$tgl,$kdtoko) {        						 
		return $this->db->select('a.tgl,a.jam,a.kdjenis,a.omset,a.keterangan,a.stokakhir,a.qty1,a.qty2,(a.qty1+a.qty2) as total,a.nmjenis')
			->where('a.tgl', $tgl)
			->where('a.jam<=', $jam)
			->where('a.kdcabang', $kdtoko)
			->where('a.kdjenis', '4')
			->get('rekapsales as a');
	
	}
	public function getpegawai() {
		$kdtoko=$this->session->userdata('kd_toko');
		$this->db->where('jabat','3');
		$this->db->where('aktif','0');
		$this->db->where('kdcab',$kdtoko);
		$this->db->order_by('jabat');
		$this->db->order_by('kdcab');
		return $this->db->get('pegawai');
	}

	public function getcustomer() {
		$kdtoko=$this->session->userdata('kd_toko');
		$this->db->where('kdcabang',$kdtoko);
		$this->db->order_by('kdcabang');
		$this->db->order_by('custno');
		return $this->db->get('customer');
	}
	
	
	public function getpromo($tgl) {
		$this->db->where('stat','1');
		$this->db->where('tglawal<=',$tgl);
		$this->db->where('tglakhir>=',$tgl);
		return $this->db->get('promoheader');
	}
	
	public function dataPengeluaranHariIni($tgl) {
		return $this->db->select('tabel_biaya.*')
			->where('tabel_biaya.tgl', $tgl)
			->where('tabel_biaya.id_user', 'kasir')
			->order_by('id')
			->get('tabel_biaya');
	}

    public function dataPengeluaranHariIniAll($tgl,$kdtoko) {
		$this->db->query("delete from rekapharian where jenis='6' and tgl='$tgl' and kdcabang='$kdtoko';");
		$this->db->query("insert ignore into rekapharian(jenis,tgl,kdcabang,kode,keterangan,nilai,nppn)
						 select '6','$tgl',kdcabang,jenis,ket,biaya,0 from tabel_biaya where tgl='$tgl' and kdcabang='$kdtoko';");	
		return $this->db->select('tabel_biaya.*')
			->where('tgl', $tgl)
			->where('kdcabang', $kdtoko)
			->order_by('id')
			->get('tabel_biaya');
	}

	public function reprintStruk($nofaktur) {
		$this->db->where('no_faktur_penjualan', $nofaktur);
		return $this->db->get('tabel_penjualan');
	}

	public function getProdukDijual($nofaktur) {
		$this->db->where('no_faktur_penjualan', $nofaktur);
		$this->db->order_by('nourut');
		return $this->db->get('tabel_rinci_penjualan');
	}
public function getProdukDijual1($nofaktur) {
		$this->db->where('no_faktur_penjualan', $nofaktur);
		$this->db->order_by('nourut');
		return $this->db->get('tabel_rinci_penjualan');
	}
    public function getRekapHarian($kdtoko,$tgl) {
		$this->db->where('jenis', '1');
		$this->db->where('kdcabang', $kdtoko);
		$this->db->where('tgl', $tgl);
		return $this->db->get('rekapharian');
	}
	public function getRekapbiaya($kdtoko,$tgl) {
		$this->db->where('jenis', '6');
		$this->db->where('kdcabang', $kdtoko);
		$this->db->where('tgl', $tgl);
		return $this->db->get('rekapharian');
	}
	
	public function datarekap($kdtoko,$tgl) {
		return  $this->db->select('SUM(IF(jenis="1",(nilai+nppn), 0)) AS omset,
		                           SUM(IF(jenis="1",(nppn), 0)) AS nppn, 
	                               SUM(IF(jenis="2",(nilai+nppn), 0)) AS discount,
	                               SUM(IF(jenis="2",(nppn), 0)) AS nppnd,
								   SUM(IF(jenis="3",(nilai+nppn), 0)) AS setor,
								   SUM(IF(jenis="4",(nilai+nppn), 0)) AS set1,
								   SUM(IF(jenis="5",(nilai+nppn), 0)) AS set2,
								   SUM(IF(jenis="6",(nilai+nppn), 0)) AS biaya,
								   SUM(IF(jenis="7",(nilai+nppn), 0)) AS ongkir,
								   SUM(IF(jenis="1",(nilai+nppn), IF(jenis="2",((nilai+nppn)*-1),0))) AS netomset,
								   (SUM(IF(jenis="1",(nilai+nppn), IF(jenis="2",((nilai+nppn)*-1),0))))+SUM(IF(jenis="7",(nilai+nppn), 0)) AS tomset,
								   (SUM(IF(jenis="1",(nilai+nppn), IF(jenis="2",((nilai+nppn)*-1),0)))-SUM(IF(jenis="3",(nilai+nppn), 0))) AS tunai,
								   (SUM(IF(jenis="6",nilai,0))+SUM(IF(jenis="3",(nilai), 0))) AS tbiaya,
									((SUM(IF(jenis="1",(nilai+nppn), IF(jenis="2",((nilai+nppn)*-1),0)))-SUM(IF(jenis="3",(nilai), 0)))-SUM(IF(jenis="6",(nilai+nppn), 0)))+SUM(IF(jenis="7",(nilai+nppn), 0)) AS saldo,
									SUM(IF(jenis="4",nppn,0)) AS nppn1,
									SUM(IF(jenis="5",nppn,0)) AS nppn2'
								   )
		->where('kdcabang', $kdtoko)
		->where('tgl', $tgl)
		->get('rekapharian');
	}
		public function datarekapd($kdtoko,$tgl) {
		return  $this->db->select('SUM(IF(layanan="1",(omset), 0)) AS dirp,
		                           SUM(IF(layanan="1",(qty1), 0)) AS diqty, 
		                           SUM(IF(layanan<>"1",(qty2), 0)) AS taqty, 
		                           SUM(IF(layanan<>"1",(omset), 0)) AS tarp,
		                           SUM(qty2+qty1)  AS ttqty,
		                           SUM(omset)  AS ttrp'
								   )
		->where('kdcabang', $kdtoko)
		->where('tgl', $tgl)
		->where('kdjenis', '4')
		->get('rekapsales');
	}
	
	public function datarekapPengeluaranHarian($kdtoko,$tgl) {
		$this->db->where('jenis', '2');
		$this->db->where('kdcabang', $kdtoko);
		$this->db->where('tgl', $tgl);
		return $this->db->get('rekapharian');
	}
	public function datarekapPengeluarantetap($kdtoko,$tgl) {
		$this->db->where('jenis', '3');
		$this->db->where('kdcabang', $kdtoko);
		$this->db->where('tgl', $tgl);
		return $this->db->get('rekapharian');
	}

	public function dataBarangMasuk($tgl) {
	$kdtoko=$this->session->userdata('kd_toko');
		$this->db->join('tabel_barang AS b', 'a.kdbrg = b.kd_barang', 'left');
		$this->db->join('stokheader AS c', 'a.nobukti = c.nobukti', 'left');
		$this->db->where('c.tgl', $tgl);
		$this->db->where('c.kegd', $kdtoko);
		$this->db->where('c.st>=', '2');
		$this->db->where('c.jtran', 'TP');
		$this->db->order_by('a.nourut');
		return $this->db->get('stokdetail AS a');
	}
	public function isidataBarangMasuk($nobukti,$kdgudang) {
	  $kdtoko=$this->session->userdata('kd_toko');
	  $is=$this->db->query("update stokheader set st='2',kegd='$kdtoko',jtran='TP'  where nobukti='$nobukti'");
	  $is=$this->db->query("update stokdetail set qtyterima=qty  where nobukti='$nobukti'");
	  
	  	
    }
    public function isidataBarangMasukd($nobukti,$kdgudang,$tgl) {
	  $kdtoko=$this->session->userdata('kd_toko');
	  $this->db2->join('stokheader as b','a.nobukti=b.nobukti','left');
	  $this->db2->where('a.nobukti',$nobukti);
	  $this->db2->where('b.tgl',$tgl);
	  $this->db2->where('b.kegd',$kdgudang);
	  $this->db2->where('b.tgl<','6');
	  return $this->db2->get('stokdetail AS a');
	  
    }
	public function getNoFaktur($kodefak) {
		$q = $this->db->query("SELECT MAX(RIGHT(no_faktur_penjualan,3)) AS id_max FROM tabel_penjualan WHERE substr(no_faktur_penjualan,1,11)='$kodefak'");
		$id_user = $this->session->userdata('ses_username');
		$kd = "";
		$kodea = $this->db->query("select kd_toko from tabel_user where id_user='$id_user';");
		$kodeaw=$kodea->row_array();
		$kodeawal=$this->session->userdata('kd_toko');
		if ($q->num_rows() > 0) {
			foreach ($q->result() as $k) {
				$tmp = ((int) $k->id_max) + 1;
				$kd = sprintf("%03s", $tmp);
			}
		} else {
			$kd = "001";
		
		}
		return $kodefak . $kd;
	}

	public function getDataPenjualan($noresi, $username) {
		$this->db->where('no_faktur_penjualan', $noresi);
		$this->db->where('id_user', $username);
		$this->db->where('selesai', '0');
		return $this->db->get('tabel_penjualan');
	}
	
	
	public function getDatadapur1($fak1) {
	    $this->db->select('a.*,count(*) as jml');
	    $this->db->join('tabel_menu as b','b.kode_menu=a.kd_barang','left');
	    $this->db->where('b.masak', '1');
		$this->db->where('a.no_faktur_penjualan', $fak1);
		$this->db->group_by('a.kd_barang');
		return $this->db->get('tabel_rinci_penjualan as a');
	}
	public function getDatadapur1a($fak1) {
	    $this->db->select('a.*,count(*) as jml');
	    $this->db->join('tabel_menu as b','b.kode_menu=a.kd_barang','left');
	    $this->db->where('b.masak', '1');
	    $this->db->where('a.nourut<', '50');
	    $this->db->where('a.no_faktur_penjualan', $fak1);
	    $this->db->where('a.idmenu', '4');
		$this->db->group_by('a.kd_barang');
		$this->db->group_by('a.idmenu');
		return $this->db->get('tabel_rinci_penjualan as a');
	}
	public function getDatadapur1b($fak1) {
	    $this->db->select('a.*,count(*) as jml');
	    $this->db->join('tabel_menu as b','b.kode_menu=a.kd_barang','left');
	    $this->db->where('b.masak', '1');
	    $this->db->where('a.nourut<', '50');
	    $this->db->where('a.idmenu', '2');
		$this->db->where('a.no_faktur_penjualan', $fak1);
		$this->db->group_by('a.kd_barang');
		$this->db->group_by('a.idmenu');
		return $this->db->get('tabel_rinci_penjualan as a');
	}
	public function getDatadapur1c($fak1) {
	    $this->db->select('a.*,count(*) as jml');
	    $this->db->join('tabel_menu as b','b.kode_menu=a.kd_barang','left');
	    $this->db->where('b.masak', '1');
	    $this->db->where('a.nourut<', '50');
	    $this->db->where('a.idmenu', '6');
		$this->db->where('a.no_faktur_penjualan', $fak1);
		$this->db->group_by('a.kd_barang');
		$this->db->group_by('a.idmenu');
		return $this->db->get('tabel_rinci_penjualan as a');
	}

	public function getDatadapur1d($fak1) {
	    $this->db->select('a.*');
	    $this->db->join('tabel_menu as b','b.kode_menu=a.kd_barang','left');
	    $this->db->where('b.masak', '1');
	    $this->db->where('a.nourut<', '50');
	    $this->db->where('a.idmenu', '5');
		$this->db->where('a.no_faktur_penjualan', $fak1);
		$this->db->group_by('a.kd_barang');
		$this->db->group_by('a.idmenu');
		return $this->db->get('tabel_rinci_penjualan as a');
	}
	
	public function getDatadapur2($fak2) {
	    $this->db->select('a.*,count(*) as jml');
	    $this->db->join('tabel_menu as b','b.kode_menu=a.kd_barang','left');
	    $this->db->where('b.masak', '1');
		$this->db->where('a.no_faktur_penjualan', $fak2);
		$this->db->group_by('a.kd_barang');
		return $this->db->get('tabel_rinci_penjualan as a');
	}
	public function getDatadapur2a($fak2) {
	    $this->db->select('a.*,count(*) as jml');
	    $this->db->join('tabel_menu as b','b.kode_menu=a.kd_barang','left');
	    $this->db->where('b.masak', '1');
	    $this->db->where('a.nourut<', '50');
	    $this->db->where('a.no_faktur_penjualan', $fak2);
	    $this->db->where('a.idmenu', '4');
		$this->db->group_by('a.kd_barang');
		$this->db->group_by('a.idmenu');
		return $this->db->get('tabel_rinci_penjualan as a');
	}
	public function getDatadapur2b($fak2) {
	    $this->db->select('a.*,count(*) as jml');
	    $this->db->join('tabel_menu as b','b.kode_menu=a.kd_barang','left');
	    $this->db->where('b.masak', '1');
	    $this->db->where('a.nourut<', '50');
	    $this->db->where('a.idmenu', '2');
		$this->db->where('a.no_faktur_penjualan', $fak2);
		$this->db->group_by('a.kd_barang');
		$this->db->group_by('a.idmenu');
		return $this->db->get('tabel_rinci_penjualan as a');
	}
	public function getDatadapur2c($fak2) {
	    $this->db->select('a.*,count(*) as jml');
	    $this->db->join('tabel_menu as b','b.kode_menu=a.kd_barang','left');
	    $this->db->where('b.masak', '1');
	    $this->db->where('a.nourut<', '50');
	    $this->db->where('a.idmenu', '6');
		$this->db->where('a.no_faktur_penjualan', $fak2);
		$this->db->group_by('a.kd_barang');
		$this->db->group_by('a.idmenu');
		return $this->db->get('tabel_rinci_penjualan as a');
	}
	public function getDatadapur2d($fak2) {
	    $this->db->select('a.*,count(*) as jml');
	    $this->db->join('tabel_menu as b','b.kode_menu=a.kd_barang','left');
	    $this->db->where('b.masak', '1');
	    $this->db->where('a.nourut<', '50');
	    $this->db->where('a.idmenu', '5');
		$this->db->where('a.no_faktur_penjualan', $fak2);
		$this->db->group_by('a.kd_barang');
		$this->db->group_by('a.idmenu');
		return $this->db->get('tabel_rinci_penjualan as a');
	}
	
	public function getDatadapur3($fak3) {
		$this->db->select('a.*,count(*) as jml');
	    $this->db->join('tabel_menu as b','b.kode_menu=a.kd_barang','left');
	    $this->db->where('b.masak', '1');
		$this->db->where('a.no_faktur_penjualan', $fak3);
		$this->db->group_by('a.kd_barang');
		return $this->db->get('tabel_rinci_penjualan as a');
	}
		public function getDatadapur3a($fak3) {
	    $this->db->select('a.*,count(*) as jml');
	    $this->db->join('tabel_menu as b','b.kode_menu=a.kd_barang','left');
	    $this->db->where('b.masak', '1');
	    $this->db->where('a.nourut<', '50');
	    $this->db->where('a.no_faktur_penjualan', $fak3);
	    $this->db->where('a.idmenu', '4');
		$this->db->group_by('a.kd_barang');
		$this->db->group_by('a.idmenu');
		return $this->db->get('tabel_rinci_penjualan as a');
	}
	public function getDatadapur3b($fak3) {
	    $this->db->select('a.*,count(*) as jml');
	    $this->db->join('tabel_menu as b','b.kode_menu=a.kd_barang','left');
	    $this->db->where('b.masak', '1');
	    $this->db->where('a.nourut<', '50');
	    $this->db->where('a.idmenu', '2');
		$this->db->where('a.no_faktur_penjualan', $fak3);
		$this->db->group_by('a.kd_barang');
		$this->db->group_by('a.idmenu');
		return $this->db->get('tabel_rinci_penjualan as a');
	}
	public function getDatadapur3c($fak3) {
	    $this->db->select('a.*,count(*) as jml');
	    $this->db->join('tabel_menu as b','b.kode_menu=a.kd_barang','left');
	    $this->db->where('b.masak', '1');
	    $this->db->where('a.nourut<', '50');
	    $this->db->where('a.idmenu', '6');
		$this->db->where('a.no_faktur_penjualan', $fak3);
		$this->db->group_by('a.kd_barang');
		$this->db->group_by('a.idmenu');
		return $this->db->get('tabel_rinci_penjualan as a');
	}
	public function getDatadapur3d($fak3) {
	    $this->db->select('a.*,count(*) as jml');
	    $this->db->join('tabel_menu as b','b.kode_menu=a.kd_barang','left');
	    $this->db->where('b.masak', '1');
	    $this->db->where('a.nourut<', '50');
	    $this->db->where('a.idmenu', '5');
		$this->db->where('a.no_faktur_penjualan', $fak3);
		$this->db->group_by('a.kd_barang');
		$this->db->group_by('a.idmenu');
		return $this->db->get('tabel_rinci_penjualan as a');
	}
	public function getDatadapur4($fak4) {
		$this->db->select('a.*,count(*) as jml');
	    $this->db->join('tabel_menu as b','b.kode_menu=a.kd_barang','left');
	    $this->db->where('b.masak', '1');
		$this->db->where('a.no_faktur_penjualan', $fak4);
		$this->db->group_by('a.kd_barang');
		return $this->db->get('tabel_rinci_penjualan as a');
	}
		public function getDatadapur4a($fak4) {
	    $this->db->select('a.*,count(*) as jml');
	    $this->db->join('tabel_menu as b','b.kode_menu=a.kd_barang','left');
	    $this->db->where('b.masak', '1');
	    $this->db->where('a.nourut<', '50');
	    $this->db->where('a.no_faktur_penjualan', $fak4);
	    $this->db->where('a.idmenu', '4');
		$this->db->group_by('a.kd_barang');
		$this->db->group_by('a.idmenu');
		return $this->db->get('tabel_rinci_penjualan as a');
	}
	public function getDatadapur4b($fak4) {
	    $this->db->select('a.*,count(*) as jml');
	    $this->db->join('tabel_menu as b','b.kode_menu=a.kd_barang','left');
	    $this->db->where('b.masak', '1');
	    $this->db->where('a.nourut<', '50');
	    $this->db->where('a.idmenu', '2');
		$this->db->where('a.no_faktur_penjualan', $fak4);
		$this->db->group_by('a.kd_barang');
		$this->db->group_by('a.idmenu');
		return $this->db->get('tabel_rinci_penjualan as a');
	}
	public function getDatadapur4c($fak4) {
	    $this->db->select('a.*,count(*) as jml');
	    $this->db->join('tabel_menu as b','b.kode_menu=a.kd_barang','left');
	    $this->db->where('b.masak', '1');
	    $this->db->where('a.nourut<', '50');
	    $this->db->where('a.idmenu', '6');
		$this->db->where('a.no_faktur_penjualan', $fak4);
		$this->db->group_by('a.kd_barang');
		$this->db->group_by('a.idmenu');
		return $this->db->get('tabel_rinci_penjualan as a');
	}
	public function getDatadapur4d($fak4) {
	    $this->db->select('a.*,count(*) as jml');
	    $this->db->join('tabel_menu as b','b.kode_menu=a.kd_barang','left');
	    $this->db->where('b.masak', '1');
	    $this->db->where('a.nourut<', '50');
	    $this->db->where('a.idmenu', '5');
		$this->db->where('a.no_faktur_penjualan', $fak4);
		$this->db->group_by('a.kd_barang');
		$this->db->group_by('a.idmenu');
		return $this->db->get('tabel_rinci_penjualan as a');
	}
	public function getDatadapur5($fak5) {
		$this->db->select('a.*,count(*) as jml');
	    $this->db->join('tabel_menu as b','b.kode_menu=a.kd_barang','left');
	    $this->db->where('b.masak', '1');
		$this->db->where('a.no_faktur_penjualan', $fak5);
		$this->db->group_by('a.kd_barang');
		return $this->db->get('tabel_rinci_penjualan as a');
	}
	public function getDatadapur5a($fak5) {
	    $this->db->select('a.*,count(*) as jml');
	    $this->db->join('tabel_menu as b','b.kode_menu=a.kd_barang','left');
	    $this->db->where('b.masak', '1');
	    $this->db->where('a.nourut<', '50');
	    $this->db->where('a.no_faktur_penjualan', $fak5);
	    $this->db->where('a.idmenu', '4');
		$this->db->group_by('a.kd_barang');
		$this->db->group_by('a.idmenu');
		return $this->db->get('tabel_rinci_penjualan as a');
	}
	public function getDatadapur5b($fak5) {
	    $this->db->select('a.*,count(*) as jml');
	    $this->db->join('tabel_menu as b','b.kode_menu=a.kd_barang','left');
	    $this->db->where('b.masak', '1');
	    $this->db->where('a.nourut<', '50');
	    $this->db->where('a.idmenu', '2');
		$this->db->where('a.no_faktur_penjualan', $fak5);
		$this->db->group_by('a.kd_barang');
		$this->db->group_by('a.idmenu');
		return $this->db->get('tabel_rinci_penjualan as a');
	}
	public function getDatadapur5c($fak5) {
	    $this->db->select('a.*,count(*) as jml');
	    $this->db->join('tabel_menu as b','b.kode_menu=a.kd_barang','left');
	    $this->db->where('b.masak', '1');
	    $this->db->where('a.nourut<', '50');
	    $this->db->where('a.idmenu', '6');
		$this->db->where('a.no_faktur_penjualan', $fak5);
		$this->db->group_by('a.kd_barang');
		$this->db->group_by('a.idmenu');
		return $this->db->get('tabel_rinci_penjualan as a');
	}
	public function getDatadapur5d($fak5) {
	    $this->db->select('a.*,count(*) as jml');
	    $this->db->join('tabel_menu as b','b.kode_menu=a.kd_barang','left');
	    $this->db->where('b.masak', '1');
	    $this->db->where('a.nourut<', '50');
	    $this->db->where('a.idmenu', '5');
		$this->db->where('a.no_faktur_penjualan', $fak5);
		$this->db->group_by('a.kd_barang');
		$this->db->group_by('a.idmenu');
		return $this->db->get('tabel_rinci_penjualan as a');
	}
	
	public function getDatadapur6($fak6) {
		$this->db->select('a.*,count(*) as jml');
	    $this->db->join('tabel_menu as b','b.kode_menu=a.kd_barang','left');
	    $this->db->where('b.masak', '1');
		$this->db->where('a.no_faktur_penjualan', $fak6);
		$this->db->group_by('a.kd_barang');
		return $this->db->get('tabel_rinci_penjualan as a');
	}
	public function getDatadapur7($fak7) {
		$this->db->select('a.*,count(*) as jml');
	    $this->db->join('tabel_menu as b','b.kode_menu=a.kd_barang','left');
	    $this->db->where('b.masak', '1');
		$this->db->where('a.no_faktur_penjualan', $fak7);
		$this->db->group_by('a.kd_barang');
		return $this->db->get('tabel_rinci_penjualan as a');
	}
	public function getDatadapur8($fak8) {
		$this->db->select('a.*,count(*) as jml');
	    $this->db->join('tabel_menu as b','b.kode_menu=a.kd_barang','left');
	    $this->db->where('b.masak', '1');
		$this->db->where('a.no_faktur_penjualan', $fak8);
		$this->db->group_by('a.kd_barang');
		return $this->db->get('tabel_rinci_penjualan as a');
	}
	public function getDatadapur9($fak9) {
		$this->db->select('a.*,count(*) as jml');
	    $this->db->join('tabel_menu as b','b.kode_menu=a.kd_barang','left');
	    $this->db->where('b.masak', '1');
		$this->db->where('a.no_faktur_penjualan', $fak9);
		$this->db->group_by('a.kd_barang');
		return $this->db->get('tabel_rinci_penjualan as a');
	}
	public function getDatadapur10($fak10) {
		$this->db->select('a.*,count(*) as jml');
	    $this->db->join('tabel_menu as b','b.kode_menu=a.kd_barang','left');
	    $this->db->where('b.masak', '1');
		$this->db->where('a.no_faktur_penjualan', $fak10);
		$this->db->group_by('a.kd_barang');
		return $this->db->get('tabel_rinci_penjualan as a');
	}
	public function getDatadapur11($fak11) {
		$this->db->select('a.*,count(*) as jml');
	    $this->db->join('tabel_menu as b','b.kode_menu=a.kd_barang','left');
	    $this->db->where('b.masak', '1');
		$this->db->where('a.no_faktur_penjualan', $fak11);
		$this->db->group_by('a.kd_barang');
		return $this->db->get('tabel_rinci_penjualan as a');
	}
	public function getDatadapur12($fak12) {
		$this->db->select('a.*,count(*) as jml');
	    $this->db->join('tabel_menu as b','b.kode_menu=a.kd_barang','left');
	    $this->db->where('b.masak', '1');
		$this->db->where('a.no_faktur_penjualan', $fak12);
		$this->db->group_by('a.kd_barang');
		return $this->db->get('tabel_rinci_penjualan as a');
	}
	public function getDatadapur13($fak13) {
		$this->db->select('a.*,count(*) as jml');
	    $this->db->join('tabel_menu as b','b.kode_menu=a.kd_barang','left');
	    $this->db->where('b.masak', '1');
		$this->db->where('a.no_faktur_penjualan', $fak13);
		$this->db->group_by('a.kd_barang');
		return $this->db->get('tabel_rinci_penjualan as a');
	}
	public function getDatadapur14($fak14) {
		$this->db->select('a.*,count(*) as jml');
	    $this->db->join('tabel_menu as b','b.kode_menu=a.kd_barang','left');
	    $this->db->where('b.masak', '1');
		$this->db->where('a.no_faktur_penjualan', $fak14);
		$this->db->group_by('a.kd_barang');
		return $this->db->get('tabel_rinci_penjualan as a');
	}
	public function getDatadapur15($fak15) {
		$this->db->select('a.*,count(*) as jml');
	    $this->db->join('tabel_menu as b','b.kode_menu=a.kd_barang','left');
	    $this->db->where('b.masak', '1');
		$this->db->where('a.no_faktur_penjualan', $fak15);
		$this->db->group_by('a.kd_barang');
		return $this->db->get('tabel_rinci_penjualan as a');
	}
	public function getDatadapurall($kdtoko,$tgl) {
		$this->db->select('a.nm_barang,sum(a.jumlah) as jumlah');
		$this->db->join('tabel_antri as b','b.nobukti=a.no_faktur_penjualan','left');
		$this->db->where('b.kdcabang', $kdtoko);
		$this->db->where('b.stat', '1');
		$this->db->where('a.nourut<', '50');
		$this->db->where('a.idmenu', '4');
		$this->db->where('b.tgl', $tgl);
		$this->db->order_by('a.kd_barang', 'ASC');
		$this->db->group_by('a.kd_barang');
		return $this->db->get('tabel_rinci_penjualan as a');
	}
		public function getDatadapuralla($kdtoko,$tgl) {
		$this->db->select('a.nm_barang,sum(a.jumlah) as jumlah');
		$this->db->join('tabel_antri as b','b.nobukti=a.no_faktur_penjualan','left');
		$this->db->where('b.kdcabang', $kdtoko);
		$this->db->where('b.stat', '1');
		$this->db->where('a.idmenu', '2');
		$this->db->where('a.nourut<', '50');
		$this->db->where('b.tgl', $tgl);
		$this->db->order_by('a.kd_barang', 'ASC');
		$this->db->group_by('a.kd_barang');
		return $this->db->get('tabel_rinci_penjualan as a');
	}
		public function getDatadapurallb($kdtoko,$tgl) {
		$this->db->select('a.nm_barang,sum(a.jumlah) as jumlah');
		$this->db->join('tabel_antri as b','b.nobukti=a.no_faktur_penjualan','left');
		$this->db->where('b.kdcabang', $kdtoko);
		$this->db->where('b.stat', '1');
		$this->db->where('a.idmenu', '6');
		$this->db->where('a.nourut<', '50');
		$this->db->where('b.tgl', $tgl);
		$this->db->order_by('a.kd_barang', 'ASC');
		$this->db->group_by('a.kd_barang');
		return $this->db->get('tabel_rinci_penjualan as a');
	}
		public function getDatadapurallc($kdtoko,$tgl) {
		$this->db->select('a.nm_barang,sum(a.jumlah) as jumlah');
		$this->db->join('tabel_antri as b','b.nobukti=a.no_faktur_penjualan','left');
		$this->db->where('b.kdcabang', $kdtoko);
		$this->db->where('b.stat', '1');
		$this->db->where('b.tgl', $tgl);
		$this->db->where('a.nourut>=', '50');
		$this->db->order_by('a.kd_barang', 'ASC');
		$this->db->group_by('a.kd_barang');
		return $this->db->get('tabel_rinci_penjualan as a');
	}
	public function getDatadapuralld($kdtoko,$tgl) {
		$this->db->select('a.nm_barang,sum(a.jumlah) as jumlah');
		$this->db->join('tabel_antri as b','b.nobukti=a.no_faktur_penjualan','left');
		$this->db->where('b.kdcabang', $kdtoko);
		$this->db->where('b.stat', '1');
		$this->db->where('a.idmenu', '5');
		$this->db->where('b.tgl', $tgl);
		$this->db->order_by('a.kd_barang', 'ASC');
		$this->db->group_by('a.kd_barang');
		return $this->db->get('tabel_rinci_penjualan as a');
	}
	
	public function getDatadapurh1($fak1) {
		$this->db->select("mid(no_faktur_penjualan,12,3) as nofak,no_faktur_penjualan,if(layanan='1','Dine In',if(layanan='2','Take Away','DO')) as makan,if(layanan='1',nomeja,'0') as meja,tgl_penjualan,waktu,layanan");
		$this->db->where('no_faktur_penjualan', $fak1);
		$this->db->where('netto>', 0);
		return $this->db->get('tabel_penjualan');
	}
	public function getDatadapurh2($fak2) {
		$this->db->select("mid(no_faktur_penjualan,12,3) as nofak,no_faktur_penjualan,if(layanan='1','Dine In',if(layanan='2','Take Away','DO')) as makan,if(layanan='1',nomeja,'0') as meja,tgl_penjualan,waktu,layanan");
		$this->db->where('no_faktur_penjualan', $fak2);
		$this->db->where('netto>', 0);
		return $this->db->get('tabel_penjualan');
	}
	public function getDatadapurh3($fak3) {
		$this->db->select("mid(no_faktur_penjualan,12,3) as nofak,no_faktur_penjualan,if(layanan='1','Dine In',if(layanan='2','Take Away','DO')) as makan,if(layanan='1',nomeja,'0') as meja,tgl_penjualan,waktu,layanan");
		$this->db->where('no_faktur_penjualan', $fak3);
		$this->db->where('netto>', 0);
		return $this->db->get('tabel_penjualan');
	}
	public function getDatadapurh4($fak4) {
		$this->db->select("mid(no_faktur_penjualan,12,3) as nofak,no_faktur_penjualan,if(layanan='1','Dine In',if(layanan='2','Take Away','DO')) as makan,if(layanan='1',nomeja,'0') as meja,tgl_penjualan,waktu,layanan");
		$this->db->where('no_faktur_penjualan', $fak4);
		$this->db->where('netto>', 0);
		return $this->db->get('tabel_penjualan');
	}
	public function getDatadapurh5($fak5) {
		$this->db->select("mid(no_faktur_penjualan,12,3) as nofak,no_faktur_penjualan,if(layanan='1','Dine In',if(layanan='2','Take Away','DO')) as makan,if(layanan='1',nomeja,'0') as meja,tgl_penjualan,waktu,layanan");
		$this->db->where('no_faktur_penjualan', $fak5);
		$this->db->where('netto>', 0);
		return $this->db->get('tabel_penjualan');
	}
	public function getDatadapurh6($fak6) {
		$this->db->select("mid(no_faktur_penjualan,12,3) as nofak,no_faktur_penjualan,if(layanan='1','Dine In',if(layanan='2','Take Away','DO')) as makan,if(layanan='1',nomeja,'0') as meja,tgl_penjualan,waktu,layanan");
		$this->db->where('no_faktur_penjualan', $fak6);
		$this->db->where('netto>', 0);
		return $this->db->get('tabel_penjualan');
	}
	public function getDatadapurh7($fak7) {
		$this->db->select("mid(no_faktur_penjualan,12,3) as nofak,no_faktur_penjualan,if(layanan='1','Dine In',if(layanan='2','Take Away','DO')) as makan,if(layanan='1',nomeja,'0') as meja,tgl_penjualan,waktu,layanan");
		$this->db->where('no_faktur_penjualan', $fak7);
		$this->db->where('netto>', 0);
		return $this->db->get('tabel_penjualan');
	}
	public function getDatadapurh8($fak8) {
		$this->db->select("mid(no_faktur_penjualan,12,3) as nofak,no_faktur_penjualan,if(layanan='1','Dine In',if(layanan='2','Take Away','DO')) as makan,if(layanan='1',nomeja,'0') as meja,tgl_penjualan,waktu,layanan");
		$this->db->where('no_faktur_penjualan', $fak8);
		$this->db->where('netto>', 0);
		return $this->db->get('tabel_penjualan');
	}
	public function getDatadapurh9($fak9) {
		$this->db->select("mid(no_faktur_penjualan,12,3) as nofak,no_faktur_penjualan,if(layanan='1','Dine In',if(layanan='2','Take Away','DO')) as makan,if(layanan='1',nomeja,'0') as meja,tgl_penjualan,waktu,layanan");
		$this->db->where('no_faktur_penjualan', $fak9);
		$this->db->where('netto>', 0);
		return $this->db->get('tabel_penjualan');
	}
	public function getDatadapurh10($fak10) {
		$this->db->select("mid(no_faktur_penjualan,12,3) as nofak,no_faktur_penjualan,if(layanan='1','Dine In',if(layanan='2','Take Away','DO')) as makan,if(layanan='1',nomeja,'0') as meja,tgl_penjualan,waktu,layanan");
		$this->db->where('no_faktur_penjualan', $fak10);
		$this->db->where('netto>', 0);
		return $this->db->get('tabel_penjualan');
	}
	public function getDatadapurh11($fak11) {
		$this->db->select("mid(no_faktur_penjualan,12,3) as nofak,no_faktur_penjualan,if(layanan='1','Dine In',if(layanan='2','Take Away','DO')) as makan,if(layanan='1',nomeja,'0') as meja,tgl_penjualan,waktu,layanan");
		$this->db->where('no_faktur_penjualan', $fak11);
		$this->db->where('netto>', 0);
		return $this->db->get('tabel_penjualan');
	}
	public function getDatadapurh12($fak12) {
		$this->db->select("mid(no_faktur_penjualan,12,3) as nofak,no_faktur_penjualan,if(layanan='1','Dine In',if(layanan='2','Take Away','DO')) as makan,if(layanan='1',nomeja,'0') as meja,tgl_penjualan,waktu,layanan");
		$this->db->where('no_faktur_penjualan', $fak12);
		$this->db->where('netto>', 0);
		return $this->db->get('tabel_penjualan');
	}
	public function getDatadapurh13($fak13) {
		$this->db->select("mid(no_faktur_penjualan,12,3) as nofak,no_faktur_penjualan,if(layanan='1','Dine In',if(layanan='2','Take Away','DO')) as makan,if(layanan='1',nomeja,'0') as meja,tgl_penjualan,waktu,layanan");
		$this->db->where('no_faktur_penjualan', $fak13);
		$this->db->where('netto>', 0);
		return $this->db->get('tabel_penjualan');
	}
	public function getDatadapurh14($fak14) {
		$this->db->select("mid(no_faktur_penjualan,12,3) as nofak,no_faktur_penjualan,if(layanan='1','Dine In',if(layanan='2','Take Away','DO')) as makan,if(layanan='1',nomeja,'0') as meja,tgl_penjualan,waktu,layanan");
		$this->db->where('no_faktur_penjualan', $fak14);
		$this->db->where('netto>', 0);
		return $this->db->get('tabel_penjualan');
	}
	public function getDatadapurh15($fak15) {
		$this->db->select("mid(no_faktur_penjualan,12,3) as nofak,no_faktur_penjualan,if(layanan='1','Dine In',if(layanan='2','Take Away','DO')) as makan,if(layanan='1',nomeja,'0') as meja,tgl_penjualan,waktu,layanan");
		$this->db->where('no_faktur_penjualan', $fak15);
		$this->db->where('netto>', 0);
		return $this->db->get('tabel_penjualan');
	}
	
	
	public function getbarang($idbarang) {
		//$this->db->where('kode_menu', $idbarang);
		//return $this->db->get('tabel_menu');
		
		$noresi = $this->uri->segment(3);
		$kod = $this->db->query("select jnsmenu,kdharga,kdcabang from tabel_penjualan where no_faktur_penjualan='$noresi';");
		$kode=$kod->row_array();
		$kdjns=$kode['jnsmenu'];
		$kdharga=$kode['kdharga'];
		$kdcabang=$kode['kdcabang'];
		$this->db->join('hargajual AS b', 'a.kode_menu = b.kdbrg' , 'left');
		$this->db->join('tabel_penjualan AS c', 'b.kdcabang = c.kdcabang and b.kdharga = c.kdharga', 'left');
		$this->db->join('promodetail AS d', 'd.kdbrg = a.kode_menu and d.idpromo = c.idpromo and  d.kdcabang=c.kdcabang', 'left');
		$this->db->where('a.kode_menu', $idbarang);
		$this->db->where('c.no_faktur_penjualan', $noresi);
		return $this->db->get('tabel_menu AS a');
	}
		


	public function cek_sudah_ada($idbarang, $nofaktur) {
		return $this->db->query("SELECT * FROM tabel_rinci_penjualan WHERE kd_barang='$idbarang' AND no_faktur_penjualan='$nofaktur'");
	}
	public function cek_ada($idbarang, $kd_toko) {
		return $this->db->query("SELECT * FROM tabel_stok_toko WHERE kd_barang='$idbarang' AND kd_toko='$kd_toko'");
	}
	public function cek_sudah_ada_order($noorder) {
		return $this->db->query("SELECT * FROM tabel_penjualan WHERE noorder='$noorder' and posting<>'0'");
	}

	public function cek_promo($nofaktur, $layan) {
		$kod = $this->db->query("select a.kdcabang,a.kdharga,a.tgl_penjualan,a.waktu,b.jnsbayar,b.id from tabel_penjualan a
								left join kodeharga b on a.kdharga=b.kdharga		
								where no_faktur_penjualan='$nofaktur';");
		$kode=$kod->row_array();
		$kdharga=$kode['kdharga'];
		$kdcabang=$kode['kdcabang'];
		$tgl=$kode['tgl_penjualan'];
		$waktu=$kode['waktu'];
		$jnsbayar=$kode['jnsbayar'];
		$idbayar=$kode['id'];
		$this->db->join('promoarea as b', 'a.nobukti=b.nobukti','left');
		$this->db->where('a.stat','1');
		$this->db->where('a.tglawal<=',$tgl);
		$this->db->where('a.tglakhir>=',$tgl);
		$this->db->where('a.jamawal<=',$waktu);
		$this->db->where('a.jamakhir>=',$waktu);
		$this->db->where('b.kdwil',$kdcabang);
		$this->db->where_in('a.jnslayanan',("0,'$layan'"));
		$this->db->where_in('a.custno',('"$jnsbayar","$idbayar",0'));
		return $this->db->get('promoheader AS a');
	}
    public function getStokskr($kdtoko,$idbarang,$tgl) {
		return $this->db->query("SELECT * FROM tabel_stok_toko  a 
		                        left join tabel_barang b on b.kd_barang=a.kd_barang
	                        	WHERE a.kd_toko='$kdtoko' and b.report>=1 and b.report<=10 
	                        	order by b.report");
	}
	
    public function datapromo($kdtoko,$tgl) {
		return $this->db->query("SELECT * FROM tabel_stok_toko  WHERE tabel_stok_toko.kd_toko='$kdtoko' and tabel_stok_toko.kd_barang='$idbarang'");
	}
	
	
	public function cek_jumlah_stok($idbarang) {
		$kdtoko = $this->session->userdata('kd_toko');
		return $this->db->query("SELECT MIN(tabel_stok_toko.stok) AS stok FROM tabel_stok_toko,tabel_rinci_menu WHERE tabel_stok_toko.kd_toko='$kdtoko' and tabel_rinci_menu.kode_bahan=tabel_stok_toko.kd_barang AND tabel_rinci_menu.kode_menu='$idbarang'");
	}

	public function getListPenjualan($noresi) {
		return $this->db->query("SELECT * FROM tabel_rinci_penjualan WHERE no_faktur_penjualan='$noresi' ORDER BY nourut");
	}

	public function getTotalBelanja($noresi) {
		return $this->db->query("SELECT SUM(sub_total_jual) AS tot_bel,SUM(sub_total_jual+nppn) AS tot_belppn FROM tabel_rinci_penjualan WHERE no_faktur_penjualan='$noresi'");
	}

	public function cari_nama($nm_barang) {
		$this->db->like('nama_menu', $nm_barang, 'both');
		$this->db->order_by('kode_menu', 'ASC');
		$this->db->limit(6);
		return $this->db->get('tabel_menu')->result();
	}

	public function getPenjualanSelesai($nofaktur) {
		$this->db->where('no_faktur_penjualan', $nofaktur);
		return $this->db->get('tabel_penjualan');
	}

	public function getPenjualanstruk($nofaktur) {
		$this->db->where('no_faktur_penjualan', $nofaktur);
		return $this->db->get('tabel_penjualan');
	}

	public function getStok($kd_barang_item) {
	    $kdtoko = $this->session->userdata('kd_toko');
		return $this->db->query("SELECT MIN(tabel_stok_toko.stok) AS stok FROM tabel_stok_toko,tabel_rinci_menu WHERE tabel_rinci_menu.kode_bahan=tabel_stok_toko.kd_barang AND tabel_rinci_menu.kode_menu='$kd_barang_item' and tabel_stok_toko.kd_toko='$kdtoko'");
	}
	
	

	public function transaksiPending($id_user, $now, $before) {
	    $kdtoko = $this->session->userdata('kd_toko');
		return $this->db->query("SELECT * FROM tabel_penjualan WHERE (selesai='0' or selesai='3')  AND kdcabang='$kdtoko' AND tgl_penjualan='$now' ORDER BY no_faktur_penjualan DESC");
	}

    public function cek_stok($kd_bahan, $kdtoko) {
		return $this->db->query("SELECT * FROM tabel_stok_toko WHERE kd_barang='$kd_bahan' and kd_toko='$kdtoko'");
	}


	public function getStokPorsi($kd_barang_item) {
		return $this->db->query("SELECT * FROM tabel_rinci_menu WHERE kode_menu='$kd_barang_item'");
	}
}

/* End of file Kasir_model.php */
/* Location: ./application/models/Kasir_model.php */